﻿<%@ Page Language="C#" AutoEventWireup="true" MasterPageFile="~/OneColumn.master" CodeBehind="ProjectActivities.aspx.cs" Inherits="GUI.Pages.Dashboard.ProjectActivities" %>

<asp:Content ID="Content3" ContentPlaceHolderID="Content" runat="server">
    <div class="page-full-main-content">
    <div class="row">
        <div class="col-md-12 col-sm-12">
            <div class="portlet light bordered light-blue kendo-form">
                    <div class="portlet-title">
                        <div class="caption">
                            <span class="caption-subject bold font-dark uppercase"> <asp:Literal ID="Literal1" runat="server" Text="<%$ Resources:ProjectManagementUI, UI_Activities %>" /> </span>
                            <span class="caption-helper"><span id="pageTitle" runat="server"></span></span>
                        </div>
                                                <div class="text-right">
                          <%--  <i class="fa fa-arrow-circle-left"></i>--%>
                       <button type="button" runat="server" onclick="backToList()"  class="btn red" value="<%$ Resources:ProjectManagementUI, Common_Back %>" id="btnBack"><i class="m-icon-swapleft m-icon-white"></i> 
                       <asp:Literal ID="Literal3" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_Back %>" />
                       </button>
                        </div>
                    </div>
                    <div class="portlet-body form">
                        <div class="form-body">
                             <telerik:RadAjaxPanel ID="RadAjaxPanel2" runat="server" EnableAJAX="true" LoadingPanelID="RadAjaxLoadingPanel2">
				            <telerik:RadGrid ID="grdList" runat="server" CssClass="kendo-table" Skin="Bootstrap"
					            PageSize="5"  AllowFilteringByColumn="true" OnItemCommand="grdTaskList_OnItemCommand"
					            AllowPaging="true" AllowSorting="true" OnNeedDataSource="grdList_OnNeedDataSource">
					            <GroupingSettings CaseSensitive="false" />
					            <PagerStyle Mode="NextPrevAndNumeric" />
					            <MasterTableView ShowHeadersWhenNoRecords="true" TableLayout="Auto" ShowFooter="False"  CssClass="table table-striped table-hover"
						            AutoGenerateColumns="False" DataKeyNames="Id" ClientDataKeyNames="Id">
						            <Columns>
							            <telerik:GridBoundColumn UniqueName="NameColumn" AllowFiltering="true" AutoPostBackOnFilter="true" CurrentFilterFunction="Contains"
								            SortExpression="Name" ShowFilterIcon="false" HeaderText="<%$ Resources:ProjectManagementUI, Common_Name %>" DataField="Name" />
							            <telerik:GridBoundColumn UniqueName="ProjectNameColumn" AllowFiltering="true" AutoPostBackOnFilter="true" CurrentFilterFunction="Contains"
								            SortExpression="Project.Name" ShowFilterIcon="false" HeaderText="<%$ Resources:ProjectManagementUI, Common_Project %>" DataField="Project.Name" />
							            <telerik:GridBoundColumn UniqueName="UsersColumn" AllowFiltering="true" AutoPostBackOnFilter="true"
                                            CurrentFilterFunction="Contains" SortExpression="UsersDisplayString" ShowFilterIcon="false"
                                            HeaderText="<%$ Resources:ProjectManagementUI, UI_Users %>" DataField="UsersDisplayString" />
							            <telerik:GridBoundColumn UniqueName="StartDateColumn" AllowFiltering="true" HeaderStyle-Width="110" AutoPostBackOnFilter="true"
								            CurrentFilterFunction="Contains" SortExpression="StartDate" ShowFilterIcon="false" DataFormatString="{0:d}" DataType="System.DateTime"
								            HeaderText="<%$ Resources:ProjectManagementUI, Common_Start %>" DataField="StartDate"  />
							            <telerik:GridBoundColumn UniqueName="EndDateColumn" AllowFiltering="true" HeaderStyle-Width="110" AutoPostBackOnFilter="true" DataFormatString="{0:d}"
								            CurrentFilterFunction="Contains" SortExpression="EndDate" ShowFilterIcon="false"
								            HeaderText="<%$ Resources:ProjectManagementUI, Common_End %>" DataField="EndDate" />
							            <telerik:GridTemplateColumn AllowFiltering="false" HeaderStyle-Width="110" HeaderText="<%$ Resources:ProjectManagementUI, Activity_Finished %>" UniqueName="IsClosedColumn" AutoPostBackOnFilter="true" CurrentFilterFunction="StartsWith" SortExpression="IsClosed" >
								            <ItemTemplate>
									            <i class="fa fa-1x fa-<%# (Eval("IsClosed").ToString() == "True") ? "check-square font-kendo-green" : "check-square font-kendo-red" %>"></i>  
								            </ItemTemplate>
								            <ItemStyle HorizontalAlign="Center" VerticalAlign="Middle" />
							            </telerik:GridTemplateColumn>
							            <telerik:GridTemplateColumn AllowFiltering="false" HeaderStyle-Width="120" HeaderText="<%$ Resources:ProjectManagementUI, Common_Progres %>" UniqueName="ProgressColumn" AutoPostBackOnFilter="true" CurrentFilterFunction="StartsWith" SortExpression="Progress" >
								            <ItemTemplate>
									             <div class="progress">
                                                <div class="progress-bar bg-kendo-<%# Convert.ToInt32(Eval("Progress")) <= 20 ? "red" : "" %><%# Convert.ToInt32(Eval("Progress")) > 20  && Convert.ToInt32(Eval("Progress")) <= 99 ? "blue" : "" %><%# Convert.ToInt32(Eval("Progress")) > 99 ? "green" : "" %>" role="progressbar" aria-valuenow="<%# Eval("Progress") %>" aria-valuemin="0" aria-valuemax="100" style="width: <%# Eval("Progress") %>%">
                                                            <span class=""> <%# Eval("Progress") %>% </span>
                                                    </div>
                                                </div> 
								            </ItemTemplate>
								            <ItemStyle HorizontalAlign="Center" VerticalAlign="Middle" />
							            </telerik:GridTemplateColumn>
							            <telerik:GridTemplateColumn AllowFiltering="false" HeaderStyle-Width="70" HeaderText="<%$ Resources:ProjectManagementUI, Common_PriorityShort %>" UniqueName="PriorityColumn" AutoPostBackOnFilter="true" CurrentFilterFunction="StartsWith" SortExpression="EnumPriority.NameLocalized" >
								            <ItemTemplate>
									             <i class="fa fa-arrow-circle-<%#(Eval("EnumPriority.Name").ToString() == "Medium" ? "right font-kendo-yellow" : "")%><%#(Eval("EnumPriority.Name").ToString() == "High" ? "up font-kendo-red" : "")%><%#(Eval("EnumPriority.Name").ToString() == "Low" ? "down font-kendo-green" : "")%>"></i>
									            <%--<a class="grid-document-link" href="<%= getVirtualPath() %>/Files/Documents/Activity/Activity<%= Request.QueryString["aid"] %>/<%# Eval("FileName") %>" target="_blank"><%# Eval("DocumentName")%></a>--%>
								            </ItemTemplate>
								            <ItemStyle HorizontalAlign="Center" VerticalAlign="Middle" />
							            </telerik:GridTemplateColumn>
							            <telerik:GridButtonColumn CommandName="Select"  HeaderStyle-Width="120"  UniqueName="SelectColumn" HeaderText=""
								            ButtonCssClass="btn btn-sm red" ButtonType="LinkButton" Text="<%$ Resources:ProjectManagementUI, Common_Choose %>">
                                             <ItemStyle HorizontalAlign="Center" VerticalAlign="Middle" />
							            </telerik:GridButtonColumn>
						            </Columns>
					            </MasterTableView>
				            </telerik:RadGrid>
			            </telerik:RadAjaxPanel>
			            <telerik:RadAjaxLoadingPanel runat="server" ID="RadAjaxLoadingPanel2">
				            <div class="updatePanelProgress">
					            <asp:Literal ID="Literal2" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_PleaseWait %>" />...
				            </div>
			            </telerik:RadAjaxLoadingPanel>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ScriptPlacerholder" runat="server">
                    <script type="text/javascript">
                     function backToList() {
                           var backLink = "<%= Session["ActivityBackLink"] %>";
                             //var appRoot = "<%= HttpRuntime.AppDomainAppVirtualPath.ToString().TrimEnd('/') %>";
                            var appRoot = window.location.protocol + "//" + window.location.host;
                             if (backLink != null) {
                                 //alert(backLink);
                                 window.location.replace(appRoot + backLink);
                                 return false;
                             }
                             else {
                                 window.history.back(1);
                                 return false;
                             }
                         }
             
                </script>
</asp:Content>
                     
